<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MasterBank extends Model 
{

    protected $table = 'master_banks';
    public $timestamps = true;
    protected $fillable = array('bank_name', 'bank_link', 'isvisible', 'alternative_link', 'logo', 'order');

    public function bank_accounts()
    {
        return $this->hasMany('App\Models\ClientBankAccount', 'master_bank_id');
    }

    public function bank_group_config()
    {
        return $this->hasMany('App\Models\BankGroupConfig', 'master_bank_id');
    }

    public function master_bank_visibility()
    {
        return $this->hasOne('App\Models\MasterBankVisibility', 'master_bank_id');
    }

}